package gov.va.med.mhv.admin.web.validator;

import java.util.ResourceBundle;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value = "unRestrictUserValidator")
public class UnRestrictUserValidator implements Validator {

	@Override
	public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {

		String unBlockNotesStr = null;
		UIInput unBlockNotes = (UIInput) component.getAttributes().get("unBlockNotes");

		if (unBlockNotes != null && unBlockNotes.getValue() != null) {
			unBlockNotesStr = (String) unBlockNotes.getValue();
		}

		if (unBlockNotesStr == null || unBlockNotesStr.isEmpty()) {
			ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
					FacesContext.getCurrentInstance().getViewRoot().getLocale());
			throw new ValidatorException(
					new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("blockDescRequired"), ""));
		}

	}

}
